# Dropzone Action Info
# Name: Shorten URL
# Description: A dropped URL will be converted to a shortened TinyURL.\nYou can also drop shortened URLs to get the expanded URL.\n\nWhen clicked, the action will either attempt to shorten or expand a URL on the clipboard or take you to your URL history on the TinyURL website if you have an API Token setup.
# Handles: Text
# Creator: Aptonic
# URL: https://aptonic.com
# OptionsNIB: TinyURL
# Events: Clicked, Dragged
# SkipConfig: No
# RunsSandboxed: Yes
# Version: 2.3
# MinDropzoneVersion: 4.0

require 'shortener'

def dragged
  $dz.determinate(false)
  shortener = Shortener.new
	shortener.process($items[0], false)
end

def clicked
  $dz.determinate(false)
  $dz.begin('Processing URL...')
  shortener = Shortener.new

  data = $dz.read_clipboard
  shortener.process(data, true)
end
